module math_head
  implicit none
  integer,parameter:: SINGLE=kind(1.0), DOUBLE=kind(1.0d0), MAXSIZE=5000,MAXNEIGHBOR=10
  real(DOUBLE),parameter :: PI=3.14159265359d0, RAD_2_ANG = 57.2957795

  TYPE :: FMM_node
     REAL(DOUBLE) :: V
     REAL(DOUBLE), dimension(:),pointer :: R(:),grad(:),pos(:),Ders(:)
     integer, dimension(MAXNEIGHBOR) :: neigh
     real(DOUBLE), dimension(MAXNEIGHBOR) :: dist
     integer :: nneigh,shep_order
     logical :: usable
  END TYPE FMM_node

  TYPE :: FMM_array
     TYPE(FMM_node), POINTER :: p
  END TYPE FMM_array

  TYPE(FMM_array), dimension(MAXSIZE) :: root

  integer, dimension(5) :: totdims
  integer :: ndim,natoms,fulldim,nimages,nroot,totdim
  real(DOUBLE) :: order,eps_shep
  real(DOUBLE),allocatable,dimension(:) :: tr0,mintr,maxtr
  real(DOUBLE),allocatable,dimension(:,:) :: shep_tr

  contains

    subroutine setup_shep_tr
      allocate(shep_tr(MAXSIZE,ndim))
    end subroutine setup_shep_tr

    subroutine add_element(RR,fixed)
      real(DOUBLE) :: RR(fulldim)
      integer, dimension(ndim) :: fixed
      integer :: i

      nroot = nroot + 1
      call setup_node(root(nroot)%p)
      root(nroot)%p%pos(1:fulldim) = RR(1:fulldim)
      do i=1,ndim
         root(nroot)%p%R(i) = RR(fixed(i))
      end do
    end subroutine add_element

    subroutine copy_E_grad(energy,grad,images)
      integer :: i,images
      real(DOUBLE) :: energy(0:images+1),grad(0:images+1,ndim)

      do i=nroot-images+1,nroot
         energy(i-(nroot-images)) = root(i)%p%V
         grad(i-(nroot-images),1:ndim) = root(i)%p%grad(1:ndim)
      end do

    end subroutine copy_E_grad

    subroutine setup_node(fmmroot)
      TYPE(FMM_node), POINTER :: fmmroot
      integer :: i

      nullify(fmmroot)
      allocate(fmmroot)
      fmmroot%V = 0
      fmmroot%usable = .true.
      do i=1,MAXNEIGHBOR
         fmmroot%dist(i) = HUGE(fmmroot%dist(i))
         fmmroot%neigh(i) = 0
      end do
      fmmroot%nneigh = 0
      fmmroot%shep_order = 0
      allocate(fmmroot%R(ndim),fmmroot%grad(ndim),fmmroot%pos(fulldim),fmmroot%Ders(totdims(nint(order))))
      
    end subroutine setup_node

    subroutine build_totdims
      integer,dimension(5) :: dims
      integer :: i,j
      
      dims=0; totdims=0
      do i=2,5
         dims(i) =1
         do j=1,i
            dims(i) = dims(i) * (ndim + j - 1)
         end do

         dims(i) = dims(i)/fact(i)
         totdims(i) = dims(i) + totdims(i-1)
      end do
      totdim = totdims(nint(order))
    end subroutine build_totdims

  RECURSIVE FUNCTION Fact(nn)
    INTEGER :: Fact
    INTEGER, INTENT(IN) :: nn

    IF (nn == 0) THEN
       Fact = 1
    ELSE
       Fact = nn * Fact(nn-1)
    END IF
  end FUNCTION Fact



end module math_head
