PROGRAM main
  use math_head
  use fileio


  real(DOUBLE) :: tr,ftol
  integer :: maxiterm,mpierr,size,rank
  logical :: restart

  call MPI_Init(mpierr)
  call MPI_Comm_size(MPI_COMM_WORLD,size,mpierr)
  call MPI_Comm_rank(MPI_COMM_WORLD,rank,mpierr)

 ! Setup mpi variables  
  call read_init_consts(ftol,maxiter,restart)
  call build_totdims ! figure out the dimensionality for math_head.f90

  fulldim = 3*natoms - 6

  call go(ftol,maxiter,restart,rank,size)

end PROGRAM main

subroutine go(ftol,maxiter,restart,rank,size)
  use math_head
  use NEB_toolbox
  use Funcs
  use MatrixOps
  use skb
  use Master
  use fileio
  use mvlsq
  use slave

  include "mpif.h"

  integer :: maxiter,i,j,mpierr,size,rank,status(MPI_STATUS_SIZE)
  real(DOUBLE) :: ftol, max_dfval,RMS
  real(DOUBLE), dimension(fulldim) :: start,finish
  real(DOUBLE), dimension(0:nimages+1,ndim) :: fullpath,grad
  real(DOUBLE), dimension(0:nimages+1,ndim) :: oldpath
  real(DOUBLE), dimension(0:nimages+1,fulldim) :: path
  real(DOUBLE), dimension(nimages,ndim) :: glast,trs
  real(DOUBLE), dimension(nimages) :: lastenergy
  real(DOUBLE), dimension(0:nimages+1) :: energy
  real(DOUBLE), dimension(nimages,ndim,ndim) :: Hs,HsSR1
  integer, dimension(ndim) :: fixed
  logical :: first_time,restart

  first_time = .TRUE.
  lastenergy = 0d0
  nroot = 0

  call read_start_finish(start,finish,fixed)

  if (rank>0) then
    call run_jobs(rank)
    CALL MPI_Finalize(mpierr)
    stop
  end if

  ! Setup the end points

 if (.not.restart) then
    call system('rm restart.info')
    call linear_interp_internal(start,finish,path,fixed) ! modifies start and finish and builds path

    call add_element(start,fixed)
    call add_element(finish,fixed)

    call run_path(2,size) ! just the start and finish
    do i=1,nimages
       call add_element(path(i,:),fixed)
    end do
!!$    call run_path(nimages,size)
!!$    call terminate_nodes(size)
!!$    CALL MPI_Finalize(mpierr)
!!$    stop
 else
    call read_in_tree
    if (nroot<2) stop
    start = root(1)%p%pos
    finish = root(2)%p%pos
    call set_path(path)
 end if
  if (order>0) call update_surface

  energy(0) = root(1)%p%V;  energy(nimages+1) = root(2)%p%V
  grad(0,:) = root(1)%p%grad;  grad(nimages+1,:) = root(2)%p%grad
  print*, "|g_start|: ", sqrt(sum(abs(root(1)%p%grad)**2))
  print*, "|g_finish|: ", sqrt(sum(abs(root(2)%p%grad)**2))

  if (natoms>3) print*, "E diff: ",(energy(nimages+1)-energy(0))*627.52d0
  fullpath(0,:) = start(fixed)
  do i=1,nimages
     fullpath(i,:) = path(i,fixed)
  end do
  fullpath(nimages+1,:) = finish(fixed)

  do i=1,ndim
     trs(1:nimages,i) = tr0(i)
  end do

  call setup_shep_tr

  ! calculate all g and E 
  do j=1,maxiter

     if (.not.restart .or. j>1) call run_path(nimages,size) ! skip the first evaluation if we are reading in the terms.
     call copy_E_grad(energy,grad,nimages)

     if (j>1.and.order>0)   then
        call calc_shep_tr
        call updatetr_local(trs)
        call update_surface
     end if

     if (natoms>3) then
        do i=0,nimages+1
           print*, "Energy:",i, (energy(i)-energy(0))*627.52d0
        end do
        print*, "barrier (kcal/mol): ", (maxval(energy)-energy(0))*627.52d0
     else
        do i=0,nimages+1
           print*, "Energy:",i, energy(i)-energy(0)
        end do
        print*, "barrier (kcal/mol): ", maxval(energy)-energy(0)
     end if

     if (j==maxiter) exit

     call Master__run_skb(fullpath,energy,grad,glast,oldpath,lastenergy,hs,HsSR1, trs, &
          ftol,first_time, max_dfval)

     call set_path(path) ! update the positions of the coordinates.

     print*, "----------path-----------"
     do i=0,nimages+1
        print*, i, fullpath(i,:)
        path(i,fixed) = fullpath(i,:)
     end do
     print*, "finished?: ", j,max_dfval,ftol
     if (max_dfval < ftol)  exit

     do i=1,nimages
        call add_element(path(i,:),fixed)
     end do
  end do

  call terminate_nodes(size)
  CALL MPI_Finalize(mpierr)

end subroutine go
