module Slave

  use math_head
  use fileio
  use Funcs
  use MatrixOps

contains
  
 subroutine run_jobs(rank)

   include "mpif.h"

   integer :: rank,tag,mpierr,status(MPI_STATUS_SIZE),index
   character(len=40) :: cmd
   logical :: failed
   real(DOUBLE) :: V0,buffer(fulldim),Der(ndim)

   index =0
   do
      index = index + 1
     ! Get the info needed to run the calculation from the master node.
    call MPI_RECV (buffer, fulldim, MPI_DOUBLE_PRECISION, 0,MPI_ANY_TAG, MPI_COMM_WORLD, status, mpierr)

    if (sqrt(sum(buffer(1:fulldim)**2))<0.00001d0) exit

    ! Run the program.
    if (natoms==3) then
!       print*, "running MB..."
       V0 = MB(buffer(1:2))
       call dMB(buffer(1:2),Der)
    else
       call run_g03(buffer,V0,Der,failed,rank)
       if (failed.or.norm(Der,ndim)==0d0 ) then
          print*, "g03 calculation failed, exiting..."
          stop
       end if
    end if

    ! Send the output back to the master node.

    call MPI_SEND(V0,1, MPI_DOUBLE_PRECISION, 0,1, MPI_COMM_WORLD,mpierr)
    call MPI_SEND(Der,ndim, MPI_DOUBLE_PRECISION, 0,1, MPI_COMM_WORLD,mpierr)
    call MPI_SEND(buffer,fulldim, MPI_DOUBLE_PRECISION, 0,1, MPI_COMM_WORLD,mpierr)

   end do

end subroutine run_jobs


end module Slave
