#!/usr/bin/perl
use strict;
use warnings;
$| = 1; # turn off buffering
my $pid = $$; # $$ holds the current process ID number
my $parent = 0; # the original process was an immaculate conception
my @kids = (); # no babies yet
my @jobs = @ARGV;
my $job;
my $i;
my $jobname;

foreach $jobname (@ARGV)
{
    my $newpid = fork();
    if ( not defined $newpid )    {

        die "fork didn't work: $!\n";

    } elsif ( $newpid == 0 ) {

        # if return value is 0, this is the child process
        $parent = $pid; # which has a parent called $pid
        $pid = $$;      # and which will have a process ID of its very own
        @kids = ();@jobs=();  # the child doesn't want this baggage from the parent
	$job=$jobname;
        last;    # and we don't want the child making babies either
    }
    else
    {
        # the parent process is returned the PID of the newborn by fork()
#        print "$$ spawned $newpid\n";
        push @kids, $newpid;
    }
}
if ( $parent ) # if I have a parent, i.e. if I'm the child process
{
#    print "I am process number $pid and I have generated this: ",$job,"\n";
    system($job);
    exit( 0 );
}
else
{
    # parent process needs to preside over the death of its kids
    while ( my $kid = shift @kids )
    {
#        print "Parent waiting for $kid to die\n";
        my $reaped = waitpid( $kid, 0 );
        unless ( $reaped == $kid )
        {
            print "Something's up: $?\n";
        }
    }
}
