!********************************************************************************************!
!============================================================================================!
!                                                                                            !
!                                     MODULE mvlsq                                           !
!                                                                                            !
! This module contains subroutines that compute the second order derivatives of potentials:  !
! Matrix_AB, SecOrder, SecDeriv, SecThirdDeriv.                                              !
!                                                                                            !
! Author: Annie LIU                                                                          !
! Provenance: 08/15/2006 Make all related subroutines a MODULE                               !
!             08/16/2006 Modified and commented by Annie Liu                                 !
!             06/11/2007 Modified and commented by Annie Liu according to the new programming!
!                        principles.                                                         !
!                                                                                            !
!============================================================================================!
MODULE mvlsq               
 USE math_head
 USE MatrixOps

SAVE

CONTAINS

  ! Sets up the linear least squares equations to determine the coefficients for the higher order derivative terms
  SUBROUTINE Matrix_AB4(I1,A,B,M)

    IMPLICIT NONE
    INTEGER :: I,J,L,P,M,K,Q,k1,cper,S
    REAL(DOUBLE) :: A(:,:),maxdist,stdout,weight
    REAL(DOUBLE) :: X(1:M,1:ndim),V(1:M),DV1(1:M,1:ndim), dX(ndim),ndx
    REAL(DOUBLE) :: DV0(1:ndim), X0(1:ndim), Wi(1:M),V0,B(1:(ndim+1)*M)
    INTEGER :: I1,ar(3),iy(3),ii,kk,jj
    integer :: per(5),dups(5),idup(5),ndup
    logical :: weighted=.true.

    weight = 1d0 ! uniform weight -> shouldn't change anything
    stdout = 3d0 
   
    ! Take the input data from the array Pot(1:no_G,1:2*ndim+1):
    DV0(1:ndim) = root(I1)%p%grad(1:ndim)
    V0 = root(I1)%p%V
    X0(1:ndim) = root(I1)%p%R

    KK = 0
    do i=1,nroot
       if (i/=I1) then
          KK = KK + 1
          V(KK) = root(i)%p%V
          DV1(KK,1:ndim) = root(i)%p%grad(1:ndim)
          X(KK,1:ndim) = root(i)%p%R(1:ndim)
       end if
    end do

    ! *** For Ax=b, setup the array b=[V_i - V_0 - dx.dV_i, dV_i - dV_0]. ***

    ! *** Find maxdist ***
    maxdist=0
    DO I=1,nroot-1
       ndx = norm(x(i,:) - x0,ndim)
       if (ndx > maxdist)       maxdist = ndx
    end DO
!    print*, "maxdist: ",maxdist

    ! *** compute weighted equations ****
    DO i=1,nroot-1
       dx = x(i,1:ndim) - x0(1:ndim)
       if (weighted) then
          B(I) = ( V(I) - V0 - DOT_PRODUCT(dx,DV0(1:ndim)) ) * exp(-0.5 * (norm(dx,ndim)/(maxdist/stdout))**2)
!          print*, norm(dx,ndim), exp(-0.5 * (norm(dx,ndim)/(maxdist/stdout))**2)
       else
          B(I) = ( V(I) - V0 - DOT_PRODUCT(dx,DV0(1:ndim)) )  * weight
       end if
    ENDDO

    KK = M + 1
    DO i = 1, nroot-1
       dx = x(i,1:ndim) - x0(1:ndim)
       DO J = 1, ndim
          if (weighted) then
             B(KK) = ( DV1(I,J) - DV0(J) ) * exp(-0.5 * (norm(dx,ndim)/(maxdist/stdout))**2)
          else
             B(KK) = ( DV1(I,J) - DV0(J) ) * weight
          end if
          KK = KK + 1
       ENDDO
    ENDDO

    ! v_i = v + dx.g + 1/2 dx.H.dx +1/6dx.Z.dx.dx + 1/24dx.dx.Q.dx.dx

    ! 2nd order A
    DO I = 1, M
       L = 0
       DO J = 1, ndim
          DO K = 1, J
             L = L + 1
             A(I,L) = (X(I,J) - X0(J))*(X(I,K) - X0(K))
             IF(K == J) A(I,L) = A(I,L)/2
          ENDDO
       ENDDO
    ENDDO

    ! 3rd order A
    if (order>2) then
    DO Q = 1, M
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                L = L + 1
                per(1)=i;per(2)=j;per(3)=k
                call num_per(per,3,cper,dups,idup,ndup)
                A(Q,L+totdims(2)) = cper*1.0/6.0*(X(Q,I) - X0(I))*(X(Q,J) - X0(J))*(X(Q,K) - X0(K))
             end DO
          ENDDO
       ENDDO
    ENDDO
    end if

    ! 4th order A
    if (order>3) then
    DO Q = 1, M
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                DO P = 1, K
                   L = L + 1
                   per(1)=i;per(2)=j;per(3)=k;per(4) = P
                   call num_per(per,4,cper,dups,idup,ndup)
                   A(Q,L+totdims(3)) = cper * 1.0/24.0 * &
                        (X(Q,I) - X0(I))*(X(Q,J) - X0(J))*(X(Q,K) - X0(K))*(X(Q,P) - X0(P))
                end DO
             end DO
          ENDDO
       ENDDO
    ENDDO
    end if

    ! 5th order A
    if (order>4) then
    DO Q = 1, M
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                DO P = 1, K
                   DO S = 1, P
                      L = L + 1
                      per(1)=i;per(2)=j;per(3)=k;per(4)=P;per(5)=S
                      call num_per(per,5,cper,dups,idup,ndup)
                      A(Q,L+totdims(4)) = cper * 1.0/120.0 * &
                           (X(Q,I) - X0(I))*(X(Q,J) - X0(J))*(X(Q,K) - X0(K))*(X(Q,P) - X0(P))*(X(Q,S) - X0(S))
                   end DO
                end DO
             end DO
          ENDDO
       ENDDO
    ENDDO
    end if

    ! g_i = g + H.dx + 1/2 dx.Z.dx + 1/6 dx.Q.dx.dx

    ! 2nd order A
    DO Q = 1, M
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             L = L + 1
             per(1) = i; per(2) = j
             call num_per(per,2,cper,dups,idup,ndup)
             do ii=1,ndup
                call calc_dx(dx(j),x(q,:),x0,idup,dups,ii,ndup,2)
                A(M + (Q-1)*ndim + idup(ii), L) = cper*dups(ii)*dx(j)/2.0
             end do
          ENDDO
       ENDDO
    ENDDO

    ! 3rd order A
    if (order>2) then
    DO Q = 1, M
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                L = L + 1
                per(1) = i; per(2) = j; per(3) = k 
                call num_per(per,3,cper,dups,idup,ndup)
                do ii=1,ndup
                   call calc_dx(dx(j),x(q,:),x0,idup,dups,ii,ndup,3)
                   A(M + (Q-1)*ndim + idup(ii), L+totdims(2)) = cper*dups(ii)*dx(j)/6.0
                end do
             end DO
          ENDDO
       ENDDO
    ENDDO
    end if

    ! 4th order A
    if (order>3) then
    DO Q = 1, M
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                DO P = 1, K
                   L = L + 1
                   per(1) = i; per(2) = j; per(3) = k ; per(4) = P
                   call num_per(per,4,cper,dups,idup,ndup)
                   do ii=1,ndup
                      call calc_dx(dx(j),x(q,:),x0,idup,dups,ii,ndup,4)
                      A(M + (Q-1)*ndim + idup(ii), L+totdims(3)) = dups(ii)*cper * dx(j)/24.0
                   end do
                end DO
             end DO
          ENDDO
       ENDDO
    ENDDO
    endif

    ! 5th order A
    if (order>4) then
    DO Q = 1, M
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                DO P = 1, K
                   DO S = 1, P
                      L = L + 1
                      per(1) = i; per(2) = j; per(3) = k ; per(4) = P; per(5) = S
                      call num_per(per,5,cper,dups,idup,ndup)
                      do ii=1,ndup
                         call calc_dx(dx(j),x(q,:),x0,idup,dups,ii,ndup,5)
                         A(M + (Q-1)*ndim + idup(ii), L+totdims(4)) = dups(ii)*cper * dx(j)/120.0
                      end do
                   end DO
                end DO
             end DO
          ENDDO
       ENDDO
    ENDDO
    endif

    ! Weight the matrix A
    KK = M + 1
    DO i = 1, nroot-1
       dx = x(i,1:ndim) - x0(1:ndim)
       if (weighted) then
          A(i,:) = A(i,:) * exp(-0.5 * (norm(dx,ndim)/(maxdist/stdout))**2)
       else
          A(i,:) = A(i,:) * weight
       end if
       DO J = 1, ndim
          if (weighted) then
             A(KK,:) = A(KK,:) * exp(-0.5 * (norm(dx,ndim)/(maxdist/stdout))**2)
          else
             A(KK,:) = A(KK,:) * weight
          end if
          KK = KK + 1
       ENDDO
    ENDDO

  END Subroutine Matrix_AB4

  subroutine calc_dx(dx,x,x0,idup,dups,ii,ndup,order)
    integer :: ii,order,j,index,idup(:),dups(:),ndup
    real(DOUBLE) :: dx,x(:),x0(:)

    if (order<2) then
       print*, "can't use order < 2 for calc_dx"
       stop
    end if

    dx = 1
    do j=1,ndup
       index=idup(j)

       if (index==idup(ii)) then  ! or j==ii
          dx = (x(index) - x0(index))**(dups(j)-1)*dx
       else
          dx = (x(index) - x0(index))**dups(j)*dx
       end if
    end do

  end subroutine calc_dx

  integer function num_dups(per,dup,num)
    integer :: i,num,per(:),dup
    num_dups = 0

    do i=1,num
       if (per(i) == dup) num_dups = num_dups+1
    end do
  end function num_dups

  subroutine num_per(per,num,out,dups,idup,ndup)
    integer :: per(:),num
    integer :: dups(:),ndup,i,j,out,idup(:)
    logical :: found


    dups=0; ndup=0; idup=0

    do i=1,num
       found = .false.
       do j=1,ndup
          if (idup(j) == per(i)) then
             dups(j) = dups(j) + 1
             found = .true.
             exit
          end if
       end do
       if (.not.found) then
          ndup = ndup + 1
          idup(ndup) = per(i)
          dups(ndup) = 1
       end if
    end do

    out = fact(num)

    do j=1,ndup
       out = out/fact(dups(j))
    end do
  end subroutine num_per

  subroutine pot_approx(R,energy,grad)
    integer :: i
    real(DOUBLE) :: energy(nroot),grad(nroot,ndim),R(ndim)

    do i=1,nroot
       call fourthorder(i,R,energy(i),grad(i,:))
    end do
  end subroutine pot_approx

  SUBROUTINE FourthOrder(I1,R,TOTAL,grad)
   
    IMPLICIT NONE
    INTEGER :: Q,L,K,I,J,I1,P,ii,S

    REAL(DOUBLE) :: Ri(1:ndim), R(1:ndim)
    REAL(DOUBLE) :: TOTAL,dx(ndim),grad(1:ndim)
    REAL(DOUBLE),dimension(:),allocatable :: A(:,:),B(:)
    integer :: per(5),dups(5),idup(5),ndup,cper,totdim

    totdim = totdims(order)
    allocate(A(ndim,totdim),B(totdim))
    Ri(1:ndim) = root(I1)%p%R
    A = 0d0

    ! higher order correction = 1/2 dx.H.dx +1/6dx.Z.dx.dx + 1/24dx.dx.Q.dx.dx

    ! 2nd order A
    L = 0
    DO J = 1, ndim
       DO K = 1, J
          L = L + 1
          A(1,L) = (R(J) - Ri(J))*(R(K) - Ri(K))
          IF(K == J) A(1,L) = A(1,L)/2
       ENDDO
    ENDDO

    ! 3rd order A
    if (order>2) then
    L = 0
    DO I = 1, ndim
       DO J = 1, I
          DO K = 1, J
             L = L + 1
             per(1)=i;per(2)=j;per(3)=k
             call num_per(per,3,cper,dups,idup,ndup)
             A(1,L+totdims(2)) = cper*1.0/6.0*(R(I) - Ri(I))*(R(J) - Ri(J))*(R(K) - Ri(K))
          end DO
       ENDDO
    ENDDO
    endif

    ! 4th order A
    if (order>3) then
    L = 0
    DO I = 1, ndim
       DO J = 1, I
          DO K = 1, J
             DO P = 1, K
                L = L + 1
                per(1)=i;per(2)=j;per(3)=k;per(4) = P
                call num_per(per,4,cper,dups,idup,ndup)
                A(1,L+totdims(3)) = cper * 1.0/24.0 * (R(I) - Ri(I))*(R(J) - Ri(J))*(R(K) - Ri(K))*(R(P) - Ri(P))
             end DO
          end DO
       ENDDO
    ENDDO
    end if

    ! 5th order A
    if (order>4) then
    L = 0
    DO I = 1, ndim
       DO J = 1, I
          DO K = 1, J
             DO P = 1, K
                do Q = 1, P
                   L = L + 1
                   per(1)=i;per(2)=j;per(3)=k;per(4) = P; per(5) = Q
                   call num_per(per,5,cper,dups,idup,ndup)
                   A(1,L+totdims(4)) = cper * 1.0/120.0 * (R(I) - Ri(I))*(R(J) - Ri(J))*(R(K) - Ri(K))*(R(P) - Ri(P))*(R(Q) - Ri(Q))
                end do
             end DO
          end DO
       ENDDO
    ENDDO
    end if

    B(1:totdims(order)) = root(I1)%p%Ders(1:totdims(order))
    TOTAL = DOT_PRODUCT(A(1,:), B) + dot_product(root(I1)%p%grad,R - root(I1)%p%R) + root(I1)%p%V

    !!!!!!!!!!!!! Grad terms

    ! 2nd order A
    L = 0
    DO I = 1, ndim
       DO J = 1, I
          L = L + 1
          per(1) = i; per(2) = j
          call num_per(per,2,cper,dups,idup,ndup)
          do ii=1,ndup
             call calc_dx(dx(j),R,root(I1)%p%R,idup,dups,ii,ndup,2)
             A(idup(ii), L) = cper*dups(ii)*dx(j)/2.0
          end do
       ENDDO
    ENDDO

    ! 3rd order A
    if (order>2) then
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                L = L + 1
                per(1) = i; per(2) = j; per(3) = k 
                call num_per(per,3,cper,dups,idup,ndup)
                do ii=1,ndup
                   call calc_dx(dx(j),R,root(I1)%p%R,idup,dups,ii,ndup,3)
                   A(idup(ii), L+totdims(2)) = cper*dups(ii)*dx(j)/6.0
                end do
             end DO
          ENDDO
       ENDDO
    end if

    ! 4th order A
    if (order>3) then
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                DO P = 1, K
                   L = L + 1
                   per(1) = i; per(2) = j; per(3) = k ; per(4) = P
                   call num_per(per,4,cper,dups,idup,ndup)
                   do ii=1,ndup
                      call calc_dx(dx(j),R,root(I1)%p%R,idup,dups,ii,ndup,4)
                      A(idup(ii), L+totdims(3)) = dups(ii)*cper * dx(j)/24.0
                   end do
                end DO
             end DO
          ENDDO
       ENDDO
    endif

    ! 5th order A
    if (order>4) then
       L = 0
       DO I = 1, ndim
          DO J = 1, I
             DO K = 1, J
                DO P = 1, K
                   DO S = 1, P
                      L = L + 1
                      per(1) = i; per(2) = j; per(3) = k ; per(4) = P; per(5) = S
                      call num_per(per,5,cper,dups,idup,ndup)
                      do ii=1,ndup
                         call calc_dx(dx(j),R,root(I1)%p%R,idup,dups,ii,ndup,5)
                         A(idup(ii), L+totdims(4)) = dups(ii)*cper * dx(j)/120.0
                      end do
                   end DO
                end DO
             end DO
          ENDDO
       ENDDO
    endif

    grad(1:ndim) = matmul(A,B) + root(I1)%p%grad(1:ndim)

  end SUBROUTINE FourthOrder

Subroutine Deriv4(i)

  IMPLICIT NONE
  INTEGER   :: i, j,M
  INTEGER   :: LWORK, RANK, INFO, nhrs 
  REAL(DOUBLE), allocatable :: Sin_val(:),WORK(:)
  REAL(DOUBLE) ::  Rcond
  REAL(DOUBLE) :: A(1:(ndim+1)*(nroot-1),1:totdim)
  REAL(DOUBLE) :: B(1:max((ndim+1)*(nroot-1),totdim))
  
  B=0.0
  A=0.0
  M = nroot-1

  CALL Matrix_AB4(i, A, B,M)

  LWORK=MAX(2*MIN(M*(ndim+1),totdim),MAX(M*(ndim+1),totdim),1)+3*MIN(M*(ndim+1),totdim)+1

  ALLOCATE(Sin_val( MIN (M*(ndim+1),totdim)),WORK(LWORK))
  Rcond = 1.0d-14
  nhrs = 1 

  CALL DGELSS(M*(ndim+1),totdim,1,A,M*(ndim+1),B,MAX(M*(ndim+1),totdim),Sin_val,&
       Rcond,RANK,WORK,LWORK,INFO)

  IF(INFO /= 0) THEN
     write(*,*)"There is a problem in DGELSS, it fails to converge!"
  ENDIF

  root(i)%p%Ders = B(1:totdim)

end Subroutine Deriv4

!!$subroutine get_weights(index)
!!$  integer :: index,i,k,j
!!$  real(DOUBLE) :: Sigma
!!$
!!$  DO k = 1, dim
!!$     Sigma = 0d0; j=0
!!$     DO jj = 1,nroot
!!$        if (jj/=index) then
!!$           j = j + 1
!!$           dX = root(j)%p%R - root(index)%p%R
!!$           deriv = root(j)%p%Der - root(index)%p%Der
!!$           Sigma = Sigma + (deriv(k)*dX(k)/(5*eps_Shep))**2/DOT_PRODUCT(dX,dX)**(no_mvlsq + 1)
!!$        end if
!!$     end DO
!!$
!!$     Sig(i,k) = (Sigma/M)**(-1.0_dbl/(no_mvlsq + 2))
!!$     if (Sigma==0) then
!!$        RMS = HUGE(RMS)
!!$        return
!!$     else
!!$        SumNor = SumNor + (ABS(R(k)-root(iref)%p%R(k))/(6*Sig(i,k)))**2
!!$        !         SumNor = SumNor + (ABS(R(k)-Pot(ref(i),k))/Sig(i,k))**2
!!$        SumSig = SumSig + (ABS(R(k)-root(iref)%p%R(k))/(2*Sig(i,k)))**(no_mvlsq + 1)
!!$     end if
!!$
!!$  ENDDO
!!$
!!$    Wv = EXP(SumNor*(-0.5d0))/SumSig
!!$    SumW = SumW + Wv(i)
!!$
!!$  DO i = 1, no_ref
!!$    W(i) = Wv(i)/SumW
!!$ end DO


END MODULE
