module fileio
  
  use math_head
  use String_Utility

  implicit none
  PRIVATE
  public :: read_start_finish,read_init_consts,read_in_tree,save_node_to_disk,run_g03,linear_interp_internal,print_internal
  Character(len=2),allocatable :: atype(:)
  Character(len=5),allocatable :: vars(:)
  integer,allocatable :: connect(:)
  logical,allocatable :: isangle(:)

  contains

! out = Mod(a,360) where 0 < out < 360
subroutine mod360(a,out,n)
  integer :: i,n
  real(DOUBLE),dimension(n) :: a,out

  do i = 1,n
     if (isangle(i)) then
        if (a(i) > PI*2d0) then
           out(i) = a(i) - 2d0*PI
        else if (a(i) < 0)  then
           out(i) = 2d0*PI + a(i)
        else
           out(i) = a(i)
        end if
     else
        out(i) = a(i)
     end if
  end do

end subroutine mod360

! out = a-b making sure the difference is mod 360
subroutine mod360diff(a,b,out,n)
  integer :: i,n
  real(DOUBLE),dimension(n) :: a,out,b

  do i = 1,n
     if (isangle(i).and. abs(a(i)+2d0*PI-b(i)) < abs(a(i)-b(i))) then
        out(i) = a(i) + 2d0*PI - b(i)
     else if (isangle(i).and. abs(a(i)-2d0*PI-b(i)) < abs(a(i)-b(i))) then
        out(i) = a(i) - b(i) - 2d0*PI
     else
        out(i) = a(i) - b(i)
     end if
  end do

end subroutine mod360diff

subroutine print_internal(vec)
  integer :: i
  real(DOUBLE),dimension(fulldim) :: vec,out


  do i=1,fulldim
     if (isangle(i)) then
        out(i) = vec(i)*RAD_2_ANG
     else
        out(i) = vec(i)
     end if
     print*, vars(i),out(i)
  end do

end subroutine print_internal

    subroutine linear_interp_internal(start,finish,path,fixed)
     integer :: i,j,fixed(ndim)
     real(DOUBLE),dimension(fulldim) :: start,finish,diff
     real(DOUBLE),dimension(0:nimages+1,fulldim) :: path
     real(DOUBLE) :: diffdx
     logical :: skip

     call mod360diff(start,finish,diff,fulldim)
!     print*, start(39)*RAD_2_ANG,finish(39)*RAD_2_ANG,diff(39)*RAD_2_ANG
     
      path(nimages+1,:) = finish

      do i=nimages,1,-1
         path(i,:) = path(i+1,:) + diff/(1d0+nimages)
      end do

      path(0,:) = start

    end subroutine linear_interp_internal

   subroutine read_init_consts(ftol,maxiter,restart)
     real(DOUBLE) :: ftol
     integer :: maxiter
     logical :: restart

     open(unit=50, FILE='file.inp')
     read(50,*) nimages  
     print*, "nimages: ", nimages
     read(50,*) ndim
     print*, "ndim: ", ndim
     read(50,*) natoms
     print*, "natoms: ", natoms
     read(50,*) maxiter
     print*, "maxiter: ", maxiter
     read(50,*) ftol
     print*, "ftol: ", ftol
     read(50,*) order
     print*, "order: ", order
     read(50,*) eps_shep
     print*, "eps_shep: ", eps_shep
     read(50,*) restart
     print*, "restart?: ", restart
     close(50)

     fulldim = 3*natoms -6
     allocate(tr0(ndim),maxtr(ndim),mintr(ndim))

   end subroutine read_init_consts

   subroutine read_in_tree
     logical :: usable
     
     OPEN(UNIT=11,FILE="restart.info")
     nroot = 1

     do 
        read(11,*,end=300) usable
        call setup_node(root(nroot)%p)
        root(nroot)%p%usable = usable
        read(11,*) root(nroot)%p%V
        read(11,*) root(nroot)%p%R(1:ndim)
        read(11,*) root(nroot)%p%grad(1:ndim)
        read(11,*) root(nroot)%p%pos(1:fulldim)
        nroot = nroot + 1
     end do
     
300  close(11)
     nroot = nroot - 1
  
   end subroutine read_in_tree

   subroutine save_node_to_disk(node)
     TYPE(FMM_node), POINTER :: node

     OPEN(UNIT=11,FILE="restart.info")
     do 
        read(11,*,end=300)
     end do
  
300  write(11,*) node%usable
     write(11,*) node%V
     write(11,*) node%R(1:ndim)
     write(11,*) node%grad(1:ndim)
     write(11,*) node%pos(1:fulldim)
     close(11)
  
   end subroutine save_node_to_disk


  subroutine read_start_finish(start,finish,fixed_coords)

     integer :: i,j,ind
     integer, dimension(ndim) :: fixed_coords
     real(DOUBLE),dimension(fulldim) :: start,finish
     real(DOUBLE) :: diffdx
     character(len=5),dimension(ndim) :: fixed
     character(len=50) :: dummy
     
     allocate(atype(natoms),connect(fulldim),vars(fulldim),isangle(fulldim))

     open(unit=50, FILE='file.inp')
     do i=1,8
        read(50,*)
     end do

     read(50,*) tr0
     read(50,*) maxtr
     read(50,*) mintr
     read(50,*) fixed(1:ndim)
     ind = 1

      do i=1,natoms
         if (i==1) then
            read(50,*) atype(i)
         else if (i==2) then
            read(50,*) atype(i),connect(ind),vars(ind)
            ind = ind + 1
         else if (i==3) then
            read(50,*) atype(i),connect(ind),vars(ind),connect(ind+1),vars(ind+1)
            ind = ind + 2
         else if (i>3) then
            read(50,*) atype(i),connect(ind),vars(ind),connect(ind+1),vars(ind+1),connect(ind+2),vars(ind+2)
            ind = ind + 3
         end if
      end do

      read(50,*)

      do i=1,fulldim
         read(50,*) dummy, start(i)
         if (index(strupcase(dummy),'R')) then
         else
            if (start(i)<0) start(i) = start(i) + 360
            start(i) = start(i)/RAD_2_ANG
         end if
      end do
      do j=1,fulldim
         isangle(j) = .not. index(strupcase(vars(j)),'R')
      end do

      do i=1,ndim
         do j=1,fulldim
            if (strcmp(fixed(i),vars(j))) then
               fixed_coords(i)=j
            end if
         end do
      end do

      read(50,*)

      do i=1,fulldim
         read(50,*) dummy, finish(i)
         if (index(strupcase(dummy),'R')) then
         else
            if (finish(i)<0) finish(i) = finish(i) + 360
            finish(i) = finish(i)/RAD_2_ANG
         end if
      end do

      close(50)

      call mod360(start,start,fulldim)
      call mod360(finish,finish,fulldim)
      
     do j=1,ndim
        i = fixed_coords(j)
        if (isangle(i)) then
           diffdx = abs(finish(i)-start(i))
           if (abs(start(i) + Pi*2d0-finish(i)<diffdx)) then
              start(i) = start(i) + Pi*2d0
           else if (abs(start(i) - Pi*2d0-finish(i)<diffdx)) then
              finish(i) = finish(i) + Pi*2d0
           end if
        end if
     end do

    end subroutine read_start_finish

  Subroutine run_g03(R, Vf, Der1,failed)

    REAL(DOUBLE) :: R(1:fulldim)
    REAL(DOUBLE), INTENT(out) :: Vf, Der1(1:ndim)
    real(DOUBLE) :: fullDerv
    character(len=5) :: vars15
    integer :: i,ind,j,istat
    logical :: failed
    failed = .false.
    ind=1

    ! Write the coordinates in internal space for g03
    OPEN(UNIT=55,FILE="coords")
    do i=1,natoms
       if (i==1) then
          write(55,*) atype(i)
       else if (i==2) then
          write(55,*) atype(i),connect(ind),vars(ind)
          ind = ind + 1
       else if (i==3) then
          write(55,*) atype(i),connect(ind),vars(ind),connect(ind+1),vars(ind+1)
          ind = ind + 2
       else if (i>3) then
          write(55,*) atype(i),connect(ind),vars(ind),connect(ind+1),vars(ind+1),connect(ind+2),vars(ind+2)
          ind = ind + 3
       end if
    end do
    write(55,*) "Variables:"
    do i=1,fulldim
       if (index(strupcase(vars(i)),'R')) then
          write(55,*) vars(i),R(i)
       else
          write(55,*) vars(i),R(i)*RAD_2_ANG
       end if
    end do
    close(55)

    ! Run g03
    call System("./run_job.sh .")

    ! Read in the optimized coordinates, energy and derivative from file fort.15.
    OPEN(UNIT=15,IOSTAT=istat)
    if (istat/=0) then
       print*, "Guassian calculation failed 0 "; failed=.true.; stop; return
    end if
    do i=1,2
       if (i==1) read(15,*,IOSTAT=istat) Vf
       if (i==2) read(15,*,IOSTAT=istat) Der1(1:ndim)
       if (istat/=0) then
          print*, "Guassian calculation failed 1"; failed=.true.; stop; return
       end if
    end do
    do i=1,fulldim
       read(15,*,end=400,IOSTAT=istat) vars15,fullDerv
       if (istat/=0) then
          print*, "coordinates not given"; goto 400
       end if
       do j=1,fulldim
          if (strcmp(vars15,vars(j))) then
             if (index(strupcase(vars(j)),'R')) then
                R(j) = fullDerv
             else
                R(j) = fullDerv/RAD_2_ANG
             end if
          end if
       end do
    end do
    print*, "success in obtaining new coordinates"
400 close(15)

    ! Adjust the radian derivatives to degrees
    Der1(1:ndim) = -Der1(1:ndim)

  END Subroutine run_g03



end module fileio
