module Master
  use math_head
  use NEB_toolbox
  use Funcs
  use MatrixOps
  use skb

  PRIVATE
  public :: Master__run_skb, run_path
contains

  subroutine run_path(images)
    use fileio
    integer :: images,i
    logical :: failed

    do i=nroot-images+1,nroot
       if (natoms==3) then
          root(i)%p%V = MB(root(i)%p%pos)
          call dMB(root(i)%p%pos,root(i)%p%grad)
       else
          call run_g03(root(i)%p%pos, root(i)%p%V, root(i)%p%grad,failed)
          if (failed.or.norm(root(i)%p%grad,ndim)==0d0 ) then
             print*, "g03 calculation failed, exiting..."
             stop
          end if
       end if
    end do

    ! Entire string saved at once.
    do i=nroot-images+1,nroot
       call save_node_to_disk(root(i)%p)
    end do

  end subroutine run_path

!!$ subroutine run_path2(path,energy,grad,images,size)
!!$   implicit none
!!$   integer :: tag,mpierr,status(MPI_STATUS_SIZE),flag,size,i,j,fmmq,images
!!$   real(dbl) :: path(images,ndim),energy(images),grad(images,ndim)
!!$   queue_empty = .false.
!!$
!!$   do
!!$      call system("sleep 0.05")
!!$
!!$      do i = 1,size-1
!!$         call MPI_IPROBE(i,MPI_ANY_TAG,MPI_COMM_WORLD,flag,status,mpierr)
!!$         write(*,*) "flag: ",i,flag
!!$         if (flag/=0) then
!!$            call MPI_RECV (V0, 1, MPI_DOUBLE_PRECISION, i, &
!!$                 MPI_ANY_TAG, MPI_COMM_WORLD, status, mpierr)
!!$            call MPI_RECV (Der, dim, MPI_DOUBLE_PRECISION, i, &
!!$                 MPI_ANY_TAG, MPI_COMM_WORLD, status, mpierr)
!!$            call MPI_RECV (pos, fulldim, MPI_DOUBLE_PRECISION, i, &
!!$                 MPI_ANY_TAG, MPI_COMM_WORLD, status, mpierr)
!!$            fmmq = find_comp_node(i)
!!$
!!$            queue(fmmq)%p%node%V = V0
!!$            queue(fmmq)%p%node%Der = Der
!!$            queue(fmmq)%p%node%pos = pos
!!$            queue(fmmq)%p%node%evaled = .true.
!!$            call update_neighbor_lists(queue(fmmq)%p%index)
!!$            print*, "cull_queue..."
!!$            call cull_queue(fmmq)
!!$            print*, "done cull_queue..."
!!$            free_comp(i)=1
!!$         end if
!!$         if (free_comp(i)==1) then
!!$            do
!!$               fmmq = get_free_queue() ! find a free node to work on from the queue                                                           
!!$               ! Exit out of the loop and get more points if                                                                                  
!!$               if (fmmq==-1) then
!!$                  print*,"queue empty";                  queue_empty = .true.;                  exit
!!$               end if
!!$
!!$               ! Try to get an interpolation value.                                                                                           
!!$               call Shepard(queue(fmmq)%p%node%R,Vp,RMS,tree_size,enough_pnts)
!!$               print*, "shepard:",enough_pnts,SQRT(RMS),eps_shep
!!$               if (eps_shep < SQRT(RMS) .or. (.not.enough_pnts)) then
!!$                  print*,"sending data",i,queue(fmmq)%p%node%pos,queue(fmmq)%p%node%R
!!$                  call MPI_SEND(queue(fmmq)%p%node%pos,fulldim, MPI_DOUBLE_PRECISION, i,1, MPI_COMM_WORLD,mpierr)
!!$                  queue(fmmq)%p%comp=i
!!$                  free_comp(i)=0
!!$                  exit
!!$               else
!!$                  ! Interpolation used                                                                                                        
!!$                  print*, "using shepard interpolation value..."
!!$                  queue(fmmq)%p%node%V = Vp;               queue(fmmq)%p%node%evaled = .false.
!!$!                  call print_queue(queue)                                                                                                    
!!$!                  print*, "fmmq R: ", fmmq%node%R,associated(fmmq,queue%next)                                                                
!!$                  call cull_queue(fmmq)
!!$               end if
!!$            end do
!!$         end if
!!$      end do
!!$      if (((.not.runall).and.queue_empty).or.(runall.and.all(free_comp==1))) exit
!!$   end do
!!$   print*,"finished with queue"
!!$
!!$ end subroutine run_queue2

  subroutine Master__run_skb(path,Efull,grad,glast,oldpath,lastenergy,Hs,hssr1,trs,  &
       ftol,first_time, max_dfval)
    integer :: i,iter

    real(DOUBLE), dimension(nimages) :: energy,equad,lastenergy,const,dfvals,aligned
    real(DOUBLE) :: dftol,spaceout_dist,ftol,dftot,max_dfval,rho,spacing,old_order
    real(DOUBLE),dimension(0:nimages+1,ndim) :: path,oldpath,grad
    real(DOUBLE),dimension(0:nimages+1) :: Efull
    real(DOUBLE),dimension(nimages,ndim) :: g,glast,force,gquad,trs
    real(DOUBLE),dimension(nimages,ndim,ndim) :: Hs,HsSR1
    real(DOUBLE),dimension(ndim) :: dx

    logical :: first_time
    
    call eqconst(path,spacing)
    print*, "Points spaced out?: ", spacing

    spaceout_dist = norm(path(0,:)-path(nimages+1,:),ndim)/(5*nimages)
    print*, "space out distance: ", spaceout_dist

    g = grad(1:nimages,:)
    energy = Efull(1:nimages)

    ! #### Set up Hessians ####
    if (first_time) then
       do i=1,nimages
          call make_I(Hs(i,:,:),ndim)
!          Hs(i,:,:) = 1.0/norm(g(i,:))*Hs(i,:,:)

          if (Efull(i+1) < Efull(i)) then
             Hs(i,:,:) = Hs(i,:,:) * abs(dot_product(grad(i,:)-grad(i-1,:),grad(i,:)-grad(i-1,:)) &
                  /dot_product(grad(i,:)-grad(i-1,:),path(i,:)-path(i-1,:)))
          else
             Hs(i,:,:) = Hs(i,:,:) * abs( dot_product(grad(i,:)-grad(i+1,:),grad(i,:)-grad(i+1,:)) &
                  /dot_product(grad(i,:)-grad(i+1,:),path(i,:) -path(i+1,:)))
          end if
       end do
       
       do i=1,nimages
          dx = path(i,:) - path(i-1,:)
          call DampedBFGSupdate(Hs(i,:,:), dx,grad(i,:)-grad(i-1,:), ndim)
          dx = path(i,:) - path(i+1,:)
          call DampedBFGSupdate(Hs(i,:,:), dx,grad(i,:)-grad(i+1,:), ndim)
       end do
       old_order = order
       order = 0d0
       max_dfval = 1d9
    else 
       print*, "sum E: ", sum(energy)
       print*, "Change in E: ", energy - lastenergy

       do i=1,nimages
          if (order<1) then
             call updateTR(Hs(i,:,:), glast(i,:), oldpath(i,:), path(i,:), energy(i), lastenergy(i), &
                  trs(i,:),mintr,maxtr, ndim,rho)
          end if
          call DampedBFGSupdate(Hs(i,:,:), path(i,:) - oldpath(i,:),g(i,:)-glast(i,:), ndim)
          
          call SR1update(HsSR1(i,:,:),g(i,:)-glast(i,:), path(i,:) - oldpath(i,:),ndim)
       end do
    end if

!!$    do i=1,nimages
!!$       call ddMB(path(i,:),Hs(i,:,:))
!!$    end do

    ! ### Check if calculation has converged ###
    call funupwind(path,g,energy,nimages,ndim,force)
    do i=1,nimages
       dfvals(i) = sqrt(sum(force(i,:)**2))
       print*, "tr:", i, norm(trs(i,:),ndim)
    end do
    max_dfval = maxval(dfvals)    
    print*, "Max dfval: ", max_dfval
    print*, "Initial dfval: ", dfvals
    
    if (maxval(dfvals)<ftol) then
       print*, "Calculation converged to dftol =",ftol
       return
    end if

    ! ### Print out alignment of path ###
    call alignment(path,aligned) 
    print*, "aligned? ", aligned

    ! ### Integrate to TRs or until finished ###
    oldpath = path
    glast = g

    lastenergy = energy

    const = 1

    do iter=1,4
       print*, "const: ", iter, const
       if (iter>1) path = oldpath
       call ODESolve(path,Hs,g,energy,nimages,ndim,trs,const,dftol,ftol)
       do i=1,nimages
          print*, i, norm(trs(i,:),ndim),norm(path(i,:) - oldpath(i,:),ndim)
       end do

       const = const /maxval(const)
       if (dftol < ftol/10) then
          exit
       end if
    end do

    print*, "done integration. Expected dftol: ",dftol

    call quad_gE(path,oldpath,Hs,g,energy,nimages,ndim,equad,gquad)
    call funupwind(path,gquad,equad,nimages,ndim,force)
    print*, "Expected change in E before potential spaceout: ", equad - lastenergy
    
    dftot = 0d0
    do i=1,nimages
       dftot = max(dftot,sqrt(sum(force(i,:)**2)))
       print*, "after dftot: ", i, sqrt(sum(force(i,:)**2))
    end do

    call eqconst(path,spacing)
    print*, "Spacing after ODEsolve: ", spacing
    do i=1,nimages
       print*, "||p_i-p_i+1||:", i, sqrt(sum((path(i,:)-path(i-1,:))**2)),sqrt(sum((path(i,:)-path(i+1,:))**2))
    end do

    ! ### Space out if necessary ###
    if (spacing > spaceout_dist) then
       do i=1,4
          call spaceoutcubic(path,nimages+2)
       end do
       call eqconst(path,spacing)
       print*, "Spacing after cubic space out: ", spacing
       call quad_gE(path,oldpath,Hs,g,energy,nimages,ndim,equad,gquad)
       call funupwind(path,gquad,equad,nimages,ndim,force)
       print*, "Expected change in E after spaceout: ", equad - lastenergy
          
       dftot = 0d0
       do i=1,nimages
          dftot = max(dftot,sqrt(sum(force(i,:)**2)))
       end do
       print*, "dftot after spaceout: ", dftot
    end if

    if (first_time) order = old_order
    first_time=.FALSE.

  end subroutine Master__run_skb

end module Master
