module Funcs
  use math_head
  use MatrixOps

  PRIVATE
  PUBLIC :: MB,dMB,ddMB
contains
  
  ! ****** Minyaev-Quapp Surface ******
  real(DOUBLE) function MQ(vars)
    real(DOUBLE),dimension(2) :: vars
    real(DOUBLE) :: x,y
    x = vars(1); y = vars(2)

    MQ = cos(2*x)+0.57*cos(2*(x-y))+cos(2*y)
  end function MQ

  real(DOUBLE) function dMQ_x(x,y)
    real(DOUBLE) :: x,y
    dMQ_x = -2d0 * sin(2d0* x) - 1.14d0* sin(2d0* x - 2d0* y)
  end function dMQ_x

  real(DOUBLE) function dMQ_y(x,y)
    real(DOUBLE) :: x,y
    dMQ_y = 1.14d0 * sin(2d0* x - 2d0* y) - 2d0* sin(2d0* y)
  end function dMQ_y

  subroutine dMQ(vars,dvars)
    real(DOUBLE),dimension(2) :: vars,dvars
    real(DOUBLE) :: x,y
    x = vars(1); y = vars(2)

    dvars(1) = dMQ_x(x,y)
    dvars(2) = dMQ_y(x,y)
!    dvars = dvars - dot_product(dvars,normal)*normal
  end subroutine dMQ

  ! ****** Muller - Brown Potential Surface *******************************************************************
  real(DOUBLE) function MB(vars)
    real(DOUBLE),dimension(2) :: vars
    real(DOUBLE) :: x,y
    real(DOUBLE),dimension(4) :: A=(/ -200.,-100.,-170.,15. /),aa=(/-1.0,-1.0,-6.5,0.7/), &
         b=(/0.,0.,11.,0.6/), c = (/-10.,-10.,-6.5,0.7/), x0=(/ 1.0,0.0,-0.5,-1.0/), y0=(/0.0,0.5,1.5,1.0/)
    integer :: i

    x = vars(1); y = vars(2)
    MB = 0d0

    do i=1,4
       MB = MB + A(i) * exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2)
    end do

  end function MB

  subroutine dMB(vars,dvars)
    real(DOUBLE),dimension(2) :: vars,dvars
    real(DOUBLE),dimension(4) :: A=(/ -200.,-100.,-170.,15. /),aa=(/-1.0,-1.0,-6.5,0.7/), &
         b=(/0.,0.,11.,0.6/), c = (/-10.,-10.,-6.5,0.7/), x0=(/ 1.0,0.0,-0.5,-1.0/), y0=(/0.0,0.5,1.5,1.0/)
    integer :: i
    real(DOUBLE) :: x,y
    x=vars(1);y=vars(2)
    dvars = 0d0

    do i=1,4
       dvars(1) = dvars(1) + A(i) * (2d0*aa(i)*(x-x0(i))+b(i)*(y-y0(i))) * &
            exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2)

       dvars(2) = dvars(2) + A(i) * (b(i)*(x-x0(i))+2d0*c(i)*(y-y0(i))) * &
            exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2)
    end do

  end subroutine dMB

  subroutine ddMB(vars,hess)
    real(DOUBLE),dimension(2) :: vars
    real(DOUBLE),dimension(2,2) :: hess
    real(DOUBLE),dimension(4) :: A=(/ -200.,-100.,-170.,15. /),aa=(/-1.0,-1.0,-6.5,0.7/), &
         b=(/0.,0.,11.,0.6/), c = (/-10.,-10.,-6.5,0.7/), x0=(/ 1.0,0.0,-0.5,-1.0/), y0=(/0.0,0.5,1.5,1.0/)
    integer :: i
    real(DOUBLE) :: x,y
    x=vars(1);y=vars(2)

    do i=1,4
       hess(1,1) = hess(1,1) + 2*A(i)*aa(i)*exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2) + &
            A(i)*(2*aa(i)*(x-x0(i))+b(i)*(y-y0(i)))**2*exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2)

       hess(1,2) = hess(1,2) + A(i)*b(i)*exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2)+ &
            A(i)*(b(i)*(x-x0(i))+2*c(i)*(y-y0(i)))*(2*aa(i)*(x-x0(i))+b(i)*(y-y0(i))) * &
            exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2)

       hess(2,1) = hess(1,2)

       hess(2,2) = hess(2,2) + 2*A(i)*c(i)*exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2) + &
            A(i)*(b(i)*(x-x0(i))+2*c(i)*(y-y0(i)))**2*exp(aa(i)*(x-x0(i))**2+b(i)*(x-x0(i))*(y-y0(i))+c(i)*(y-y0(i))**2)
    end do

  end subroutine DdMB


  subroutine MB_start_finish(start,finish)
    real(DOUBLE),dimension(2) :: start,finish

    start = (/ -0.5582236346, 1.441725842/);
    finish = (/ 0.6234994049, 0.02803775853 /);
  end subroutine MB_start_finish



 end module Funcs

