#!/opt/sharcnet/python/2.7.1/bin/python2.7
import math
import sys
import argparse
from atoms import *
from fileio import *

# The purpose of this script is to generate .com files for scanning.

parser = argparse.ArgumentParser(description='Creates new frcmod based on fitting the data in finished_runs.dat.')
parser.add_argument('frcmod_file', action="store")
parser.add_argument('mol2_file', action="store")
parser.add_argument('opt_xyz_file', action="store")
args = parser.parse_args()

# Read in the mol2 file for atom types and connections. Replace the xyz and charges with the log file data above.
frc = frcmod(args.frcmod_file)
mol = Molecule()
mol.read_mol2(args.mol2_file)
bonds,angles,diheds = mol.build_bond_angle_dihed_list()
bb,ans,dis,skip_dis,nn_dihed = frc.move_list(bonds,angles,diheds,mol)

# Read in the closest constrained optimization coordinate set.
print args.opt_xyz_file
mol.read_replace_xyz(args.opt_xyz_file)

# Calculate the internal coordinates.
internal = bb;internal.extend(ans);internal.extend(dis)
eq_vals = frc.get_first_internals(mol,internal)

frc.set_constants(eq_vals,10,20,0.1) # Set the bonds, angles and dihedrals to constant values.

# Write out the frcmod file.
frc.write("full_const.frcmod")
