#!/usr/bin/perl

use POSIX;

#
# Given job name gives .xyz file from .log file. Uses .com for atom names.
#

$job = $ARGV[0];

open(FILE,$job);
$on=0;
while(<FILE>) {
    if (/orientation/) {
	$on =1;@arr=();@atoms=();
    }
    if (/SCF Done:.+\=\s+([\d\-\.]+)/ || /^\s*Energy\s*\=\s+([\-\.\d]+)\s*NIter/ || /EUMP2\s*\=\s+([\-\.\dD\+]+)/) {
	if ($lastenergy && $1>$lastenergy) {
	    # skip
	} else {
	    $lastenergy = $1;
	    @newxyz = @xyz;
	}
    }
    if ($on && /\s+[\-\.\d]+\s+[\-\.\d]+\s+[\-\.\d]+/) {
	@line = split(/\s+/,$_);
	push(@atoms,num_to_aname($line[2]-1));
	$on=2;push(@arr,[$line[4],$line[5],$line[6]]);
	if ($line[4] =~ /Na/ || $line[5] =~ /Na/ || $line[6] =~ /Na/) { $on=0; }
    }
    if ($on==2 && /^\s\-/) {
	$on=0;
	@xyz=();
	$xyz[0] = (0+@atoms) . "\ncomment\n";
	for($i=0;$i<@arr;$i++) {
	    $xyz[$i+1] = "$atoms[$i]  " .  join("  ",@{ $arr[$i] }) . "\n";
	}

    }
}
close(FILE);
print @xyz;

sub num_to_aname {
    my @names = qw(H He Li Be B C N O F Ne Na Mg Al Si P S Cl Ar K Ca Sc Ti V Cr Mn Fe Co Ni Cu Zn Ga Ge As Se Br Kr Rb Sr Y Zr Nb Mo Tc Ru Rh Pd Ag Cd In Sn Sb Te I Xe);

    return $names[$_[0]];
}

