#!/usr/bin/perl

use POSIX;

#
# Given job name gives .xyz file from .log file. Uses .com for atom names.
#

$job = $ARGV[0];
$on=0;
while(<>) {
    if (/orientation/) {
	$on =1;@arr=();@atoms=();
    }
    if (/SCF Done:.+\=\s+([\d\-\.]+)/ || /^\s*Energy\s*\=\s+([\-\.\d]+)\s*NIter/ || /EUMP2\s*\=\s+([\-\.\dD\+]+)/) {
	if ($lastenergy && $1>$lastenergy) {
	    # skip
	} else {
	    $lastenergy = $1;
	    @newxyz = @xyz;
	}
    }
    if ($on && /\s+[\-\.\d]+\s+[\-\.\d]+\s+[\-\.\d]+/) {
	@line = split(/\s+/,$_);
	push(@atoms,num_to_aname($line[2]-1));
	$on=2;push(@arr,[$line[4],$line[5],$line[6]]);
	if ($line[4] =~ /Na/ || $line[5] =~ /Na/ || $line[6] =~ /Na/) { $on=0; }
    }
    if ($on==2 && /^\s\-/) {
	$on=0;
	@xyz=();
	for($i=0;$i<@arr;$i++) {
	    $xyz[$i] = "$atoms[$i]  " .  join("  ",@{ $arr[$i] }) . "\n";
	}
    }
}

for($i=0;$i<@xyz;$i++) {
    ($type,@x2) = split(/\s+/,$xyz[$i]);
    $res = "ZNC";$chain="";$res_num=1;

    if (length($type)==4) {
	printf("ATOM  %5d %-4s %-4s%s%4d     % 7.3f % 7.3f % 7.3f\n",$i+1,$type,
	       $res, $chain,$res_num,$x2[0],$x2[1],$x2[2]);
    } else {
	printf("ATOM  %5d  %-3s %-4s%s%4d     % 7.3f % 7.3f % 7.3f\n",$i+1,$type,
	       $res, $chain,$res_num,$x2[0],$x2[1],$x2[2]);
    }
}

sub num_to_aname {
    my @names = qw(H He Li Be B C N O F Ne Na Mg Al Si P S Cl Ar K Ca Sc Ti V Cr Mn Fe Co Ni Cu Zn Ga Ge As Se Br Kr Rb Sr Y Zr Nb Mo Tc Ru Rh Pd Ag Cd In Sn Sb Te I Xe);

    return $names[$_[0]];
}
