import re
import sys
import math
from atoms import *

if len(sys.argv) != 4:
    print "usage: <terms> <.mol2 file> <.frcmod file>"
    sys.exit(0)

# Find the values in allterms using the list of atom types 'at'.
# eg. at = [ h5-n2-cu-os         1.1          180.0         1.0          General improper torsional angle (2 general atom types) ] 

def find_terms(n,at,allterms,attn):

    # If improper dihedral.
    improp=0
    if (n==5):
        improp=1
        n=4
        
    str1 = at[0]
    str2 = at[n-1]
    for i in range(n-1):
        str1 = str1 + "-" + at[i+1]
    for i in range(n-1):
        str2 = str2 + "-" + at[n-i-2]

#    print str1,str2

    if (allterms[n].has_key(str1)):
        combo = str1
    elif (allterms[n].has_key(str2)):
        combo = str2
    else:
        print "Could not find parameter: ", at
        sys.exit(0)

    if (n==2 or n==3):
#        print "check: ", allterms[n][combo][1][0], float(at[n])
        new = max(allterms[n][combo][1][0]/1 + float(at[n]),10.0)
#        new = max(allterms[n][combo][1][0],0)
#        print allterms[n][combo][1]
        out = combo + '     {0:8.3f}  {1:8.3f}'.format(new,allterms[n][combo][1][1])
        return out
    if (n==4 and improp==1):
#        new = max(float(at[4])+allterms[4][combo][1][1]/4,0) #+ float(at[n+1])/float(at[7])/float(at[7]),0)
        new = max(float(at[4])+allterms[4][combo][1][1],0) #+ float(at[n+1])/float(at[7])/float(at[7]),0)        
        out = combo + '   {0:8.3f}    180.0     2.0'.format(new)
#        print allterms[4][combo]
        return out
    elif (n==4):
#        new = max(allterms[n][combo][1][1],0) #+ float(at[n+1])/float(at[7])/float(at[7]),0)
#        new = max(allterms[n][combo][1][1]+float(at[n+1])/float(at[7])/float(at[7]),0)
        new = max(allterms[n][combo][1][1]/float(at[7])/float(at[7]),0)
        if (allterms[n][combo][1][1]<0 and -allterms[n][combo][1][1]> float(at[n+1])/float(at[7])/float(at[7])):
            new = float(at[n+1])/float(at[7])/float(at[7])/2
            
        #        print "check: ", float(at[7]), float(at[n+1]),allterms[n][combo][1][1]
        if (float(at[7])==0):
            at[7]="1.0"
        if attn:
            out = combo + '   {0}  {1:8.3f}  {2}  {3}'.format(at[4],new,allterms[n][combo][1][2],at[7])
        else:
            out = combo + '   {0}  {1:8.3f}  {2}  {3}'.format(at[4],new,at[6],at[7])
        return out

    if (n>4 or n<1):
        print "Unknown parameter"; sys.exit(0)


# Read in .mol2 file.
mol = Molecule("mol2")
mol.read_mol2(sys.argv[2])

# Read in bond and angle terms from 'terms' file and store them in structure allterms.
# allterms[2/3/4]['CA-H1'/'CT-H'] = (1,300.0,1.08) 
f = open(sys.argv[1],'r') # terms file (e.g. "38  51: 1000.000  1.519" )

allterms = ({},{},{},{},{})

for line in f:
    matched = re.match('\s*(.+):(.+)',line) # match the line
    terms = map(int,matched.group(1).split()) # atom numbers before the ":".
    vals = matched.group(2).split()  # [K_q, r_eq]
    nterms = len(terms) # 2 = bonds, 3 = angles, 4 = dihedrals
    if nterms>1 and nterms<5:

        # Convert atom numbers into atom types.
        str1 = mol.atoms[terms[0]].atype
        for i in range(nterms-1):
            str1 = str1 + "-" + mol.atoms[terms[i+1]].atype

        if allterms[nterms].has_key(str1):
            old = allterms[nterms][str1]
            if (len(vals)==2):
                for i in range(len(old[1])):
                    vals[i] = float(vals[i])
                    vals[i] += old[0]*old[1][i]
                    vals[i] /= (old[0]+1)
            else:
                vals[1] = float(vals[1])
                vals[1] += old[0]*old[1][1]
                vals[1] /= (old[0]+1)
#            print "adjust: ", old
            allterms[nterms][str1] = (old[0]+1,vals)
#            print "adjust: ", vals
        else:
            if (len(vals)==2): vals = map(float,vals)
            if (len(vals)==4): vals[1] = float(vals[1])
            if (len(vals)==4): vals[2] = float(vals[2])
            allterms[nterms][str1] = (1,vals)
   #         if (len(vals)==4): 
  #              print nterms,str1,allterms[nterms][str1][1]
 #               print allterms[nterms][str1][1][1]
#                sys.exit(0)

f.close()

# Setup dictionary of nonbonded and mass terms.
mass = {'O': "16.00         0.465", 'Z': "65.39"           , 'N': "14.01         0.530   "}
nonb = {'O': " 1.6837  0.1700  "  , 'Z' : "1.95      0.250", 'N': "   1.8240  0.1700 "    }

# Collect the missing terms to be obtained from the .frcmod file.
f = open(sys.argv[3],'r')
section =0
for line in f:
    if (re.search('MASS',line)): section = 1
    if (re.search('BOND',line)): section = 2
    if (re.search('ANGLE',line)): section = 3
    if (re.search('DIHE',line)): section = 4
    if (re.search('IMPR',line)): section = 5
    if (re.search('NONBON',line)): section = 6

    m = re.search('[\d\.\-]+',line)
    if (section>1 and section < 6 and m):
        num = len(line.split('-')) # should match the section number
        ar = re.split('[\-\s]+',line)
        attn = re.search("ATTN",line)

        if (section==1):
            if mass.has_key(out[0]):
                print ar[0],mass[out[0]]
            else:
                print line
        elif (section>1 and section<6):
            bondinfo = find_terms(section,ar,allterms,attn)
            if (bondinfo):
                print bondinfo
        elif (section==6):
            if nonb.has_key(out[0]):
                print ar[0],nonb[out[0]]
            else:
                print line
        else:
            print line,
    else:
        print line,
        


f.close()
