import re
import sys,os
import math
from copy import *
from numpy import *
from numpy.linalg import *
from math_fun import *

class amber:
    def __init__(self,prefix):
        self.parms = None
        self.formats = None        
        self.prefix = prefix
        self.xyz = []
        self.natoms = 0
        self.bond_matrix = None

    def build_bond_list(self):
        labels = ['BONDS_INC_HYDROGEN','BONDS_WITHOUT_HYDROGEN']
        bonds = []
        
        for j in range(2):
            hbond = map(int,self.parms[labels[j]])
            for i in range(len(hbond)/3):
                bonds.append((hbond[3*i]/3,hbond[3*i+1]/3))

        return bonds

    def build_angle_list(self):
        labels = ['ANGLES_INC_HYDROGEN','ANGLES_WITHOUT_HYDROGEN']
        angles = []

        for j in range(2):
            hbond = map(int,self.parms[labels[j]])
            for i in range(len(hbond)/4):
                angles.append((hbond[4*i]/3,hbond[4*i+1]/3,hbond[4*i+2]/3))

        return angles

    def build_dihed_list(self):
        """ AMBER FF dihedral energy """
        labels = ['DIHEDRALS_INC_HYDROGEN','DIHEDRALS_WITHOUT_HYDROGEN']
        diheds = []

        for j in range(2):
            hbond = map(int,self.parms[labels[j]])
            hbond = map(abs,hbond)
            for i in range(len(hbond)/5):
                a = abs(hbond[5*i]/3)
                b = abs(hbond[5*i+1]/3)
                c = abs(hbond[5*i+2]/3)
                d = abs(hbond[5*i+3]/3)
                diheds.append((a,b,c,d))

        return diheds

    def read_parm_file(self):
        """ Read in an Amber .lib file """
        filename = self.prefix + ".prmtop"
        f = open(filename,'r')
        num = 0
        key = None
        self.parms = {};        self.formats = {}
        self.keys = []
        for line in f:
            m = re.search('\%FLAG ([\w\_\d]+)',line)
            if (m):
                num = 1
#                if (key):
#                    self.parms[key] = vals
                key = m.group(1)
                self.keys.append(key)
                self.parms[key] = []
            elif(num==1):
                m = re.search('\%FORMAT\((\d+)(\w)(.+)\)',line)
                self.formats[key] = m.groups()
                num = num + 1
            elif(num==2):
                if (self.formats[key][1] == 'a'):
                    numf = int(self.formats[key][0])
                    width = int(self.formats[key][2])
                    L = []
                    for i in range(min(numf,len(line)/width)):
                        L.append(line[i*width:(i+1)*width])
                else:
                    L = line.split()
                self.parms[key].extend(L)
        f.close()
        
        self.natoms = int(self.parms['POINTERS'][0])







