import math
import sys
import numpy
import argparse

from atoms import *

parser = argparse.ArgumentParser(description='Add charges to a mol2 file.')
parser.add_argument('mol2file', action="store")
parser.add_argument('chargefile', action="store")
parser.add_argument('-fi', help='the type of file to get charges from')
parser.add_argument('-fo', help='name of .mol2 output file',default="out.mol2")
args = parser.parse_args()

mol = Molecule("pdb")
mol.read_mol2(args.mol2file)
if (args.fi=="log"):
    mol2 = gaussian_log_file(args.chargefile)
    charges = mol2.read_esp_points()
    mol.assign_charges(charges)
#    mol.copy_charges(mol2)
elif (args.fi=="charge"):
    mol.read_in_charges(args.chargefile)
    
mol.write_mol2(args.fo)
