
AIMPAC Utilities                                                    relief(3)
 
NAME
     relief - produces relief maps of GRID or GRIDV output
 
SYNOPSIS
     relief grdfile relfile
 
DESCRIPTION
 
        The relief program reads in a grid of data (grdfile) 
        output by GRID and produces a relief map of the function,
        output to relfile.  This is done using interactive queries
        of the user for plotting information.  The resulting file
        is then redirected to the output device for plotting.
 
ARGUMENTS
 
     grdfile (for example 'hcoh.grd')
        The grdfile contains a grid of data output by the program
        GRID.
 
     relfile (for example 'hcoh.rel')
        The output relfile contains the plotter calls to produce
        the relief map.  This output file is redirected to the 
        plotter directly. (for example 'cat hcoh.rel > /dev/tty02')
 
INTERACTIVE DIALOG
 
        Once the prograsm has read in the grid of data the following
        questions are asked of the user;
 
        1) EYE POSITION IN THREE-SPACE
 
        2) MAGNIFICATION, CUTOFF, VERTICAL ACCENTUATION
 
        The first question requests the location of the user's
        viewpoint while viewing the relief map.  The input
        values are coordinates, the ratio of which is the important
        consideration.  The lengths of each side of the grid are
        treated as unit vectors.  For example, 
 
        EYE POSITION IN THREE-SPACE  1.0,1.0,0.6
 
        will generate a map such that the viewer is looking across
        the map from the X = 1.0, Y = 1.0 corner to the X = 0.0, Y = 0.0
        corner, from a height of 0.6 the length of the edges.  This is
        a good starting point for experimentation with views of rho and
        the transition density.  For del-squared rho, using -0.6 for the
        third value will give a view in which the maxima in -del-squared
        rho will be positive peaks.
 
        The second request asks for the magnification of the map, the 
        cutoff or maximum value shown, and the vertical accentuation
        to be given the values.  A typical response would be
 
        MAGNIFICATION, CUTOFF, VERTICAL ACCENTUATION
        1.0,10.0,3.0
 
        which specifies that the map be produced without any
        size modification, with a maximum value of 10 au., and
        the peaks will appear to be three-times higher than they
        normally would appear.
 
EXAMPLES
 
     relief hcoh hcoh
        This requests a calculation of the relief map of the function
        in hcoh.grd.
 
SEE ALSO
     grid(3), contor(3)
 
Release 1.0                       AIMPAC                            relief(3)

